/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker.audio;

import com.talpie.linker.audio.FrameCodec;
import com.talpie.linker.audio.Transport;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OutboundSender
implements AutoCloseable,
Runnable {
    private final Transport transport;
    private final String route;
    private final UUID streamId;
    private final BlockingQueue<byte[]> src;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Thread thread;
    private int seq = 0;

    public OutboundSender(Transport transport, String route, UUID streamId, BlockingQueue<byte[]> src) {
        this.transport = transport;
        this.route = route;
        this.streamId = streamId;
        this.src = src;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.thread = new Thread((Runnable)this, "OutboundSender");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.running.get()) {
                byte[] frame;
                byte[] payload = frame = this.src.take();
                byte[] msg = FrameCodec.pack(this.streamId, this.seq++, payload, false);
                this.transport.sendRequest(this.route, msg);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() {
        this.running.set(false);
    }
}

