/*
 * Decompiled with CFR 0.152.
 */
package com.talpie.linker;

import com.talpie.linker.AES;
import com.talpie.linker.ClientService;
import com.talpie.linker.Message;
import com.talpie.linker.RSA;
import com.talpie.linker.StatiCom;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class DataSocketClient {
    private final ClientService clientService;
    private final Socket socket;
    private final String socketId;
    private final ExecutorService socketExecutor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean running = false;
    private RSA rsa;
    private AES aes;
    private OutputStream out;
    private InputStream in;
    private final ConcurrentHashMap<String, CompletableFuture<Message>> pending = new ConcurrentHashMap();
    private static final ScheduledExecutorService SCHED = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService sendExecutor = Executors.newSingleThreadExecutor();

    public String getId() {
        return this.socketId;
    }

    public DataSocketClient(ClientService clientService, Socket socket, String socketId) {
        this.clientService = clientService;
        this.socket = socket;
        this.socketId = socketId;
        this.rsa = clientService.getRsa();
        this.aes = clientService.getAes();
        try {
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket.setReceiveBufferSize(65536);
            socket.setSendBufferSize(65536);
        }
        catch (Exception e) {
            clientService.getListenersHandlers().error(this, e);
        }
    }

    public void start() {
        this.running = true;
        try {
            this.out = this.socket.getOutputStream();
            this.in = this.socket.getInputStream();
            if (this.handshake()) {
                this.clientService.getListenersHandlers().dataOpen(this, this);
                this.socketExecutor.submit(this::socketReceiveLoop);
            } else {
                this.stop();
            }
        }
        catch (Exception e) {
            this.clientService.getListenersHandlers().error(this, e);
            this.stop();
        }
    }

    public void stop() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.running = false;
        try {
            IllegalStateException ex = new IllegalStateException("Connection closed");
            this.pending.forEach((id, fut) -> fut.completeExceptionally(ex));
            this.pending.clear();
            this.clientService.removeDataSocket(this.socketId);
            this.socketExecutor.shutdownNow();
            this.sendExecutor.shutdownNow();
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            this.clientService.getListenersHandlers().dataClose(this, this);
        }
        catch (Exception e) {
            this.clientService.getListenersHandlers().error(this, e);
        }
    }

    public CompletableFuture<Message> sendRequest(String route, byte[] payload) {
        return this.sendRequest(route, payload, 0L);
    }

    public CompletableFuture<Message> sendRequest(String route, byte[] payload, long timeoutMillis) {
        Message req = new Message(route, payload);
        req.setPayload(payload);
        CompletableFuture<Message> fut = new CompletableFuture<Message>();
        this.pending.put(req.getMessageId(), fut);
        this.sendExecutor.submit(() -> {
            block2: {
                try {
                    this.writeMessage(req);
                }
                catch (Exception e) {
                    CompletableFuture<Message> p = this.pending.remove(req.getMessageId());
                    if (p == null || p.isDone()) break block2;
                    p.completeExceptionally(e);
                }
            }
        });
        if (timeoutMillis > 0L) {
            SCHED.schedule(() -> {
                CompletableFuture<Message> p = this.pending.remove(req.getMessageId());
                if (p != null && !p.isDone()) {
                    p.completeExceptionally(new Exception("Timeout waiting for response: " + req.getMessageId()));
                }
            }, timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return fut;
    }

    private boolean handshake() {
        try {
            StatiCom.writeLine(this.out, "#_START-DATA-SOCKET++" + this.clientService.getClientId() + this.socketId + this.rsa.sign(this.clientService.getClientId() + this.socketId));
            String confirmation = this.aes.decrypt(StatiCom.readLineString(this.in));
            if (!"#_DATA-SOCKET-READY++".equals(confirmation)) {
                throw new Exception("Socket confirmation failed: " + confirmation);
            }
            this.clientService.getListenersHandlers().dataHandshakeCompleted(this, this);
            return true;
        }
        catch (Exception e) {
            this.clientService.getListenersHandlers().dataHandshakeFailed(this, this, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void socketReceiveLoop() {
        block10: {
            try {
                if (!this.running) break block10;
                String encHeaderStr = StatiCom.readLineString(this.in);
                byte[] encHeader = Base64.getDecoder().decode(encHeaderStr);
                byte[] headerPlain = this.aes.decrypt(encHeader, null);
                String header = new String(headerPlain, StandardCharsets.UTF_8);
                Message msg = Message.fromHeader(header);
                int total = msg.getLength().intValueExact();
                byte[] encPayload = total > 0 ? this.readPayloadWithProgress(this.in, total, msg) : new byte[]{};
                byte[] plain = total > 0 ? this.aes.decrypt(encPayload, encHeader) : new byte[]{};
                msg.setPayload(plain);
                try {
                    this.clientService.getStats().snapshot();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.clientService.getStats().onMsgRx(msg.getRoute());
                if (msg.getType() == '1') {
                    CompletableFuture<Message> fut = this.pending.remove(msg.getMessageId());
                    if (fut != null) {
                        fut.complete(msg);
                    }
                    this.clientService.getListenersHandlers().dataResponse(this, this, msg);
                } else {
                    Message resp = this.clientService.getListenersHandlers().dataRequest(this, this, msg);
                    this.writeMessage(resp);
                }
            }
            catch (Exception e) {
                this.clientService.getListenersHandlers().error(this, e);
            }
            finally {
                this.stop();
            }
        }
    }

    private byte[] readPayloadWithProgress(InputStream in, int total, Message msg) throws Exception {
        int got;
        byte[] buf = new byte[total];
        long recvd = 0L;
        int lastPercent = -1;
        for (int off = 0; off < total; off += got) {
            int want = Math.min(1024, total - off);
            got = in.read(buf, off, want);
            if (got != -1) continue;
            throw new EOFException("EOF during payload read");
        }
        return buf;
    }

    private void onReceiveProgress(Message msg, long recvd, long total, int percent) {
        this.clientService.getListenersHandlers().progressDataRx(this, this, msg, recvd, total, percent);
    }

    private void onSendProgress(Message msg, long sent, long total, int percent) {
        this.clientService.getListenersHandlers().progressDataTx(this, this, msg, sent, total, percent);
    }

    private void writeMessage(Message msg) throws Exception {
        if (msg == null) {
            return;
        }
        try {
            this.clientService.getStats().onMsgTx(msg.getRoute());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byte[] plainPayload = msg.getPayload();
        int encLen = this.aes.encryptedLength(plainPayload.length);
        byte[] saved = plainPayload;
        msg.setPayload(new byte[encLen]);
        String headerStr = msg.getHeader();
        msg.setPayload(saved);
        String encHeaderStr = this.aes.encrypt(headerStr);
        StatiCom.writeLine(this.out, encHeaderStr);
        byte[] encHeader = Base64.getDecoder().decode(encHeaderStr);
        byte[] encPayload = this.aes.encrypt(plainPayload, encHeader);
        assert (encPayload.length == encLen);
        msg.setPayload(encPayload);
        BigInteger lenBI = msg.getLength();
        if (lenBI.signum() > 0) {
            int total = msg.getPayload().length;
            if (lenBI.compareTo(BigInteger.valueOf(total)) != 0) {
                throw new IllegalStateException("Header length mismatch: header=" + String.valueOf(lenBI) + " bytes, actual=" + total);
            }
            long sent = 0L;
            int lastPercent = -1;
            for (int offset = 0; offset < total; offset += 1024) {
                int chunk = Math.min(1024, total - offset);
                this.out.write(msg.getPayload(), offset, chunk);
                this.out.flush();
                int percent = (int)((sent += (long)chunk) * 100L / (long)total);
                if (percent == lastPercent) continue;
                this.onSendProgress(msg, sent, total, percent);
                lastPercent = percent;
            }
        }
    }
}

